#!/bin/tcsh


#based on Smith_ et al., PNAS, 2009
#===============Auditory Network, AN =====================
#a1: left primary and association auditory cortices
#a2: right primary and association auditory cortices

# =============Attention Network ==== AttN ===============
#f1/f2:left/right middle frontal gyrus
#p1/p2: left/right superior parietal lobule

# =======Default Mode network ===  DMN ===================
#d1: precuneus/posterior cingulate
#d2: bilateral temporal-parietal
#d3: ventromedial frontal cortex

# ==========Executive control network == ECN =============
#e1: anterior cingulate cortex
#e2: bilateral medial frontal gyrus

# ==========fronto-parietal network == FPN =============
#f3/f4:left/right inferior frontal gyrus
#p3/p4:left/right infereior parietal lobule

# ==========-Salience network == SLN =============
#s1: anterior aspect of the body of the cingulate gyrus
#s2: left insula
#s3: right insula

# # ==========Sensorimotor network == SMN =============
#m1: left primary motor cortex (left motor area)
#m2: supplementary motor area
#m3: right primary motor cortex (right motor area)
# # ==========Visual network == VN =============

#v1: medial visual areas
#v2: occipital visual areas
#v3: latreal visual areas

set path = ($path /data/brutus_data0/freeware/afni)
echo $path

#  export PATH=$PATH:/data/brutus_data0/freeware/afni
# -------- path for afni  ------------
# ====== ReHo.nii.gz is a 4D image, formed afetr merging the ReHo map from all the subjects for the given dataset===

set imdir = /data/.../FC_reho_SB_DR/ReHo_Analy/Coll_ReHomap
set roidir = /data/.../FC_reho_SB_DR_FC/ReHo_Analy/RSN_Rois
#cp $imdir/ReHo.nii.gz  $outdir/ReHo.nii.gz

#========= AN   ======================================
3dROIstats -quiet -mask  $roidir/a1+tlrc $imdir/ReHo.nii.gz  > a1.txt
3dROIstats -quiet -mask  $roidir/a2+tlrc $imdir/ReHo.nii.gz  > a2.txt
1dcat a1.txt a2.txt > AdN.txt

#================== AttN ==============================
3dROIstats -quiet -mask  $roidir/f1+tlrc $imdir/ReHo.nii.gz  > f1.txt
3dROIstats -quiet -mask  $roidir/f2+tlrc $imdir/ReHo.nii.gz  > f2.txt
3dROIstats -quiet -mask  $roidir/p1+tlrc $imdir/ReHo.nii.gz  > p1.txt
3dROIstats -quiet -mask  $roidir/p2+tlrc $imdir/ReHo.nii.gz  > p2.txt
1dcat f1.txt f2.txt p1.txt p2.txt > AtN.txt

#================== DMN    ===========================
3dROIstats -quiet -mask  $roidir/d1+tlrc $imdir/ReHo.nii.gz  > d1.txt
3dROIstats -quiet -mask  $roidir/d2+tlrc $imdir/ReHo.nii.gz  > d2.txt
3dROIstats -quiet -mask  $roidir/d3+tlrc $imdir/ReHo.nii.gz  > d3.txt
1dcat d1.txt d2.txt d3.txt > DMN.txt

#================== ECN    ===========================
3dROIstats -quiet -mask  $roidir/e1+tlrc $imdir/ReHo.nii.gz  > e1.txt
3dROIstats -quiet -mask  $roidir/e2+tlrc $imdir/ReHo.nii.gz  > e2.txt
1dcat e1.txt e2.txt > ECN.txt

#================== FPN  =============================
3dROIstats -quiet -mask  $roidir/f3+tlrc $imdir/ReHo.nii.gz  > f3.txt
3dROIstats -quiet -mask  $roidir/f4+tlrc $imdir/ReHo.nii.gz  > f4.txt
3dROIstats -quiet -mask  $roidir/p3+tlrc $imdir/ReHo.nii.gz  > p3.txt
3dROIstats -quiet -mask  $roidir/p4+tlrc $imdir/ReHo.nii.gz  > p4.txt
1dcat f3.txt f4.txt p3.txt p4.txt > FPN.txt

#================== SLN    ===========================
3dROIstats -quiet -mask  $roidir/s1+tlrc $imdir/ReHo.nii.gz  > s1.txt
3dROIstats -quiet -mask  $roidir/s2+tlrc $imdir/ReHo.nii.gz  > s2.txt
3dROIstats -quiet -mask  $roidir/s3+tlrc $imdir/ReHo.nii.gz  > s3.txt
1dcat s1.txt s2.txt s3.txt > SlN.txt

#================== SMN    ===========================
3dROIstats -quiet -mask  $roidir/m1+tlrc $imdir/ReHo.nii.gz  > m1.txt
3dROIstats -quiet -mask  $roidir/m2+tlrc $imdir/ReHo.nii.gz  > m2.txt
3dROIstats -quiet -mask  $roidir/m3+tlrc $imdir/ReHo.nii.gz  > m3.txt
1dcat m1.txt m2.txt m3.txt > SMN.txt

#================== VN   =============================
3dROIstats -quiet -mask  $roidir/v1+tlrc $imdir/ReHo.nii.gz  > v1.txt
3dROIstats -quiet -mask  $roidir/v2+tlrc $imdir/ReHo.nii.gz  > v2.txt
3dROIstats -quiet -mask  $roidir/v3+tlrc $imdir/ReHo.nii.gz  > v3.txt
1dcat v1.txt v2.txt v3.txt > VsN.txt

1dcat AdN.txt AtN.txt DMN.txt ECN.txt FPN.txt SlN.txt SMN.txt VsN.txt > All_KCC1.txt
rm a*.txt f*.txt p*.txt d*.txt e*.txt s*.txt m*.txt v*.txt *N.txt

#   can be used for the existing brain altas template , e.g. Brainnotome Atlas (246 parcellation)

#  3dROIstats -quiet -mask  BN_Atlas_246_2mm.nii ReHo.nii.gz  > ReHo_BNA246.txt

